<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @author Daniele Termini
 */

require __DIR__ . '/../pongho/vendor/autoload.php';
require_once __DIR__ . '/src/Updater.php';
require_once __DIR__ . '/functions.php';

use function Pongho\Updates\authenticate_user;
use function Pongho\Updates\display_errors;

display_errors();
authenticate_user();

$bootstrap_file = __DIR__ . '/../pongho/src/bootstrap.php';

if (!file_exists($bootstrap_file)) {
    exit(sprintf('File %s does not exist!', $bootstrap_file));
}

const PONGHO_MODE = 'update';
const ROOT_PATH = __DIR__ . '/..';

require $bootstrap_file;
