<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @author Daniele Termini
 */

require __DIR__ . '/../pongho/vendor/autoload.php';
require_once __DIR__ . '/src/Updater.php';
require_once __DIR__ . '/functions.php';

use Pongho\Updates\Updater;
use function Pongho\Updates\authenticate_user;
use function Pongho\Updates\display_errors;
use function Pongho\Updates\redirect;

display_errors();
authenticate_user();

$action = $_GET['action'] ?? null;

$site_path = dirname(__DIR__);
$site_dir = rtrim(dirname(substr($_SERVER['SCRIPT_FILENAME'], strlen($_SERVER['DOCUMENT_ROOT'])), 2), '/');
$site_protocol = empty($_SERVER['HTTPS']) ? 'http' : 'https';
$site_host = $_SERVER['HTTP_HOST'] ?? 'localhost';
$site_url = $site_protocol . '://' . $site_host . $site_dir;

$updater = new Updater($site_path, $site_url, $site_dir);

switch ($action) {
    case 'activate-maintenance':
        try {
            $updater->activateMaintenance();
            redirect($site_url . '/updates/');
        } catch (Throwable $e) {
            $updater->showError($e->getMessage());
        }
        break;

    case 'deactivate-maintenance':
        try {
            $updater->deactivateMaintenance();
            redirect($site_url . '/updates/');
        } catch (Throwable $e) {
            $updater->showError($e->getMessage());
        }
        break;

    case 'update':
        try {
            $updater->update();
            redirect($site_url . '/updates/');
        } catch (Throwable $e) {
            $updater->showError($e->getMessage());
        }
        break;

    case 'fast-update':
        try {
            $updater->activateMaintenance();
            $updater->update();
            $updater->deactivateMaintenance();
            redirect($site_url . '/updates/');
        } catch (Throwable $e) {
            $updater->showError($e->getMessage());
        }
        break;

    default:
        $updater->showHome();
        break;
}
