<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 */

namespace Pongho\Updates;

use JetBrains\PhpStorm\NoReturn;

function display_errors(): void
{
    ini_set('display_errors', 1);
    error_reporting(-1);
}

function authenticate_user(): void
{
    $expected_username = 'metaline';
    $expected_password = 'ildebrando';

    $username = null;
    $password = null;

    if (isset($_SERVER['PHP_AUTH_USER'])) {
        $username = $_SERVER['PHP_AUTH_USER'];
        $password = $_SERVER['PHP_AUTH_PW'];
    } else {
        $authorizationHeader = null;
        if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
            $authorizationHeader = $_SERVER['HTTP_AUTHORIZATION'];
        } elseif (isset($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])) {
            $authorizationHeader = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
        }

        if (null !== $authorizationHeader && 0 === stripos($authorizationHeader, 'basic ')) {
            $exploded = explode(':', base64_decode(substr($authorizationHeader, 6)), 2);

            if (count($exploded) === 2) {
                [$username, $password] = $exploded;
            }
        }
    }

    if ($username !== $expected_username || $password !== $expected_password) {
        header('HTTP/1.0 401 Unauthorized');
        header('WWW-Authenticate: Basic realm="Metaline Updater"');
        header('Content-type: text/plain; charset: utf-8');

        echo 'Questa è un’area riservata!';

        exit;
    }
}

#[NoReturn]
function redirect(string $url): void
{
    header('HTTP/1.1 303 See Other');
    header("Location: $url");
    exit;
}
