<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\WebTracking\GoogleAnalytics;

use Application\Showcase\Entity\OrderInterface;
use Application\Showcase\Entity\OrderRowInterface;

/**
 * Ecommerce
 *
 * TODO: Gestione delle valute. @link https://developers.google.com/analytics/devguides/collection/analyticsjs/ecommerce#currency
 */
class Ecommerce
{
    /**
     * @param OrderInterface $order
     * @param string         $taxonomy
     * @param string         $affiliation
     * @param string         $tracker
     * @return string
     */
    public function render(OrderInterface $order, $taxonomy = 'category', $affiliation = null, $tracker = null)
    {
        if ($tracker) {
            $tracker = $tracker . '.';
        }

        $code = "ga('{$tracker}require','ecommerce');";
        $code .= $this->getTransactionJs($order, $affiliation, $tracker);

        foreach ($order->getRows() as $row) {
            $code .= $this->getItemJs($row, $taxonomy, $tracker);
        }

        $code .= "ga('{$tracker}ecommerce:send');";

        return '(function(){' . $code . '})();';
    }

    /**
     * @param OrderInterface $order
     * @param string         $affiliation
     * @param string         $tracker
     * @return string
     */
    protected function getTransactionJs(OrderInterface $order, $affiliation, $tracker)
    {
        $transaction = [
            'id'       => $order->getId(),
            'revenue'  => $this->getCurrencyValue($order->total()),
            'shipping' => $this->getCurrencyValue($order->shippingCost()),
            'tax'      => $this->getCurrencyValue($order->taxCost()),
        ];

        if ($affiliation) {
            $transaction['affiliation'] = $affiliation;
        }

        $transaction = json_encode($transaction);

        return "ga('{$tracker}ecommerce:addTransaction',$transaction);";
    }

    /**
     * @param OrderRowInterface $row
     * @param string            $taxonomy
     * @param string            $tracker
     * @return string
     */
    protected function getItemJs(OrderRowInterface $row, $taxonomy, $tracker)
    {
        $item = [
            'id'       => $row->getOrderId(),
            'name'     => $row->title(),
            'sku'      => $row->sku(),
            'price'    => $this->getCurrencyValue($row->price()),
            'quantity' => $row->quantity(),
        ];

        $category = $row->getProduct()->getTerm($taxonomy);

        if ($category) {
            $item['category'] = $category->title();
        }

        $item = json_encode($item);

        return "ga('{$tracker}ecommerce:addItem',$item);";
    }

    /**
     * @param mixed $value
     * @return float
     */
    private function getCurrencyValue($value)
    {
        return (float) $value;
    }
}
