<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Utilities;

use Application\Core\Model\Site;

/**
 * Contenitore per le opzioni di default del negozio.
 */
class Config
{
    /**
     * Restituisce le opzioni di default del negozio.
     *
     * @param \Application\Core\Model\Site $site Il sito di riferimento.
     * @return array
     */
    public static function getDefault(Site $site)
    {
        return [
            'enable_offers'                        => false,
            'order_discounts'                      => [],

            'shopping_point_cost'                  => 0,
            'shopping_point_value'                 => 0,
            'shopping_point_min_points'            => 0,
            'shopping_point_min_total_order'       => 0,
            'shopping_point_on_single_product'     => false,
            'shopping_point_calculate_on_subtotal' => true,

            'enable_tax'                           => false,
            'tax_value'                            => 0,
            'tax_name'                             => '',

            'enable_guest_checkout'                => false,
            'enable_order_note'                    => false,

            'orders_email'                         => $site->getOption('company_email'),

            'enable_google_shopping'               => false,
        ];
    }
}
