<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

/**
 * Update69.
 */
class Update69 extends SchemaUpdate
{
    /**
     * prepareSchema
     *
     * @param \Doctrine\DBAL\Schema\Schema $schema
     */
    protected function prepareSchema(Schema $schema)
    {
        $orders_table = $schema->getTable('pongho_orders');

        $orders_table->addColumn('invoice_province_id', 'integer', array('unsigned' => true, 'notnull' => false));

        $orders_table->addForeignKeyConstraint(
            $schema->getTable('pongho_provinces'),
            array('invoice_province_id'),
            array('id'),
            array('onDelete' => 'SET NULL')
        );

        $orders_table->addColumn('shipping_province_id', 'integer', array('unsigned' => true, 'notnull' => false));

        $orders_table->addForeignKeyConstraint(
            $schema->getTable('pongho_provinces'),
            array('shipping_province_id'),
            array('id'),
            array('onDelete' => 'SET NULL')
        );
    }
}
