<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Application\Core\Model\Translation;
use Updates\BaseUpdate;

/**
 * Update63.
 */
class Update63 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        Translation::putTranslation('shop_login_submit', 'Continua', 'showcase', 'it_IT');
        Translation::putTranslation('shop_subscribe_submit', 'Crea un account', 'showcase', 'it_IT');

        Translation::putTranslation('required_codice_fiscale', 'Il campo “Codice Fiscale” è obbligatorio!', 'showcase', 'it_IT');
        Translation::putTranslation('invalid_codice_fiscale', 'Il Codice Fiscale inserito non è valido!', 'showcase', 'it_IT');

        Translation::putTranslation('use_for_shipping', 'Invia a questo indirizzo', 'showcase', 'it_IT');
        Translation::putTranslation('save_address', 'Invia a questo indirizzo', 'showcase', 'it_IT');
        Translation::putTranslation('delete_address', 'Elimina indirizzo', 'showcase', 'it_IT');
    }
}
