<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

/**
 * Update51.
 *
 * Sconti sugli ordini, fase 1: aggiungo le nuove tabelle.
 */
class Update51 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $ordersTable = $schema->getTable('pongho_orders');
        $ordersTable->addColumn('discount_id', 'integer', array('unsigned' => true, 'notnull' => false));
        $ordersTable->addColumn('discount_name', 'string', array('length' => 255));
        $ordersTable->addColumn('discount_value', 'decimal', array('precision' => 12, 'scale' => 4));

        $discountTable = $schema->createTable('pongho_orders_discounts');
        $discountTable->addColumn('id', 'integer', array('unsigned' => true, 'autoincrement' => true));
        $discountTable->addColumn('handler_name', 'string', array('length' => 255));
        $discountTable->addColumn('code', 'string', array('length' => 255));
        $discountTable->addColumn('expire_on', 'date');
        $discountTable->setPrimaryKey(array('id'));

        $discountConditionsTable = $schema->createTable('pongho_orders_discounts_conditions');
        $discountConditionsTable->addColumn('id', 'integer', array('unsigned' => true, 'autoincrement' => true));
        $discountConditionsTable->addColumn('discount_id', 'integer', array('unsigned' => true, 'notnull' => false));
        $discountConditionsTable->addColumn('value', 'decimal', array('precision' => 12, 'scale' => 4));
        $discountConditionsTable->addColumn('value_type', 'string', array('length' => 1));
        $discountConditionsTable->addColumn('condition', 'decimal', array('precision' => 12, 'scale' => 4));
        $discountConditionsTable->setPrimaryKey(array('id'));

        $ordersTable->addForeignKeyConstraint(
            $discountTable,
            array('discount_id'),
            array('id')
        );

        $discountConditionsTable->addForeignKeyConstraint(
            $discountTable,
            array('discount_id'),
            array('id')
        );
    }
}
