<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Application\Admin\Model\AdminModule;
use Application\Core\Model\Permit;
use Application\Core\Model\PermitRole;
use Application\Core\Model\Translation;
use Updates\BaseUpdate;

class Update21 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $modules = AdminModule::allByName('shop');
        $shop_module = reset($modules);

        if ($shop_module) {
            // Permesso generico di amministrazione dello shop
            $permit = Permit::findByKey('shop.admin');

            if ($permit === null) {
                $permit = Permit::create(
                    array(
                        'key' => 'shop.admin',
                        'is_enabled' => true,
                    )
                );
            }

            $options = array(
                'conditions' => array('permit_id = ?', $permit->id),
            );

            $roles = array();
            foreach (PermitRole::all($options) as $permit_role) {
                /** @var \Application\Core\Model\PermitRole $permit_role */
                $roles[] = $permit_role->role_id;
            }

            if ($shop_module->permit_id != $permit->id) {
                $shop_module->permit_id = $permit->id;
                $shop_module->save();
            }

            // Permessi degli altri moduli
            $permits = array(
                array(
                    'key' => 'shop.coupons',
                    'admin_controller' => 'Application\\Showcase\\Controller\\Admin\\CouponsController',
                    'translation' => 'Può gestire i codici coupon',
                ),
                array(
                    'key' => 'shop.orders',
                    'admin_controller' => 'Application\\Showcase\\Controller\\Admin\\OrdersController',
                    'translation' => 'Può gestire gli ordini',
                ),
                array(
                    'key' => 'shop.payments',
                    'admin_controller' => 'Application\\Showcase\\Controller\\Admin\\PaymentsController',
                    'translation' => 'Può gestire i metodi di pagamento',
                ),
                array(
                    'key' => 'shop.shippings',
                    'admin_controller' => 'Application\\Showcase\\Controller\\Admin\\ShippingsController',
                    'translation' => 'Può gestire i metodi di trasporto',
                ),
                array(
                    'key' => 'shop.sizes',
                    'admin_controller' => 'Application\\Showcase\\Controller\\Admin\\SizesController',
                    'translation' => 'Può gestire le taglie',
                ),
                array(
                    'key' => 'shop.stats',
                    'admin_controller' => 'Application\\Showcase\\Controller\\Admin\\StatsController',
                    'translation' => 'Può visualizzare le statistiche',
                ),
            );

            foreach ($permits as $data) {
                $modules = AdminModule::allByController($data['admin_controller']);

                if (!empty($modules)) {
                    $permit = Permit::findByKey($data['key']);

                    if ($permit === null) {
                        $permit = Permit::create(
                            array(
                                'key' => $data['key'],
                                'is_enabled' => true,
                            )
                        );

                        Translation::putTranslation('permit_' . $data['key'], $data['translation'], 'showcase', 'it_IT');
                    }

                    foreach ($roles as $role_id) {
                        PermitRole::create(
                            array(
                                'permit_id' => $permit->id,
                                'role_id' => $role_id,
                            )
                        );
                    }

                    foreach ($modules as $module) {
                        $module->permit_id = $permit->id;
                        $module->save();
                    }
                }
            }
        }
    }
}
