<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Application\Core\Installer\Helper\DatabaseSchemaHelper;
use Application\Core\Installer\Helper\TranslationsHelper;
use Doctrine\DBAL\Schema\Schema;
use Updates\BaseUpdate;

/**
 * Update200
 *
 * Sistemazioni nella procedura di evasione dell’ordine.
 */
class Update200 extends BaseUpdate
{
    public function commit()
    {
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema) {

            $ordersTable = $schema->getTable('pongho_orders');

            if (!$ordersTable->hasColumn('process_note')) {
                $ordersTable->addColumn('process_note', 'text', ['length' => 65535, 'default' => '']);
            }

        });

        (new TranslationsHelper($this->connection))
            ->setCulture('it_IT')
            ->addTranslation('process_note', 'Note', 'showcase')
            ->addTranslation('tracking_code', 'Codice di tracciamento', 'showcase')
        ;
    }
}
