<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Application\Core\Installer\Helper\DatabaseSchemaHelper;
use Application\Core\Installer\Helper\TranslationsHelper;
use Doctrine\DBAL\Schema\Schema;
use Updates\BaseUpdate;

/**
 * Update193
 *
 * Modifica del database per far coesistere i vari sconti applicabili agli ordini.
 */
class Update193 extends BaseUpdate
{
    public function commit()
    {
        /**
         * Fix: C'era un bug con le scontistiche. Se il tipo di sconto era impostato a "Raccolta punti",
         * ogni volta che si salvava il pannello delle opzioni dello shop veniva creata una nuova riga
         * nella tabella "pongho_orders_discounts"
         */
        $sth = $this->connection->prepare('SELECT id, settings FROM pongho_sites');
        $sth->execute();

        foreach ($sth as $site) {
            $options = unserialize($site['settings']);
            $discountType = isset($options['order_discount_type']) ? $options['order_discount_type'] : '';

            switch ($discountType) {
                case 'coupon_code':
                    $this->connection->exec(
                        "DELETE FROM pongho_orders_discounts WHERE handler_name <> 'shop_coupon_discount'"
                    );

                    break;

                case 'order_amount':
                case 'shopping_points':
                    $service = "shop_{$discountType}_discount";

                    $firstId = $this->connection->fetchColumn(
                        "SELECT MIN(id) FROM pongho_orders_discounts WHERE handler_name = '{$service}'"
                    );

                    $this->connection->exec(
                        "DELETE FROM pongho_orders_discounts_conditions WHERE discount_id <> {$firstId}"
                    );

                    $this->connection->exec(
                        "DELETE FROM pongho_orders_discounts WHERE id <> {$firstId}"
                    );

                    break;
            }
        }

        /**
         * Preparo il nuovo schema in database
         */
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema) {

            $ordersTable = $schema->getTable('pongho_orders');

            // Tabella per gli sconti
            if ($schema->hasTable('pongho_shop_order_discounts')) {
                $orderDiscountsTable = $schema->getTable('pongho_shop_order_discounts');
            } else {
                $orderDiscountsTable = $schema->createTable('pongho_shop_order_discounts');
                $orderDiscountsTable->addColumn('id', 'integer', ['unsigned' => true, 'autoincrement' => true]);
                $orderDiscountsTable->addColumn('handler_name', 'string', ['length' => 255, 'default' => '']);
                $orderDiscountsTable->addColumn('code', 'string', ['length' => 255, 'default' => '']);
                $orderDiscountsTable->addColumn('expire_on', 'datetime', ['notnull' => false, 'default' => null]);
                $orderDiscountsTable->setPrimaryKey(array('id'));
            }

            // Tabella per le condizioni degli sconti
            if (!$schema->hasTable('pongho_shop_order_discounts_conditions')) {
                $orderDiscountsConditionsTable = $schema->createTable('pongho_shop_order_discounts_conditions');
                $orderDiscountsConditionsTable->addColumn('id', 'integer', ['unsigned' => true, 'autoincrement' => true]);
                $orderDiscountsConditionsTable->addColumn('discount_id', 'integer', ['unsigned' => true, 'notnull' => true]);
                $orderDiscountsConditionsTable->addColumn('value', 'decimal', ['precision' => 12, 'scale' => 4, 'default' => 0]);
                $orderDiscountsConditionsTable->addColumn('value_type', 'string', ['length' => 1, 'default' => '']);
                $orderDiscountsConditionsTable->addColumn('condition', 'decimal', ['precision' => 12, 'scale' => 4, 'default' => 0]);
                $orderDiscountsConditionsTable->setPrimaryKey(['id']);
                $orderDiscountsConditionsTable->addForeignKeyConstraint($orderDiscountsTable, ['discount_id'], ['id']);
            }

            // Tabella degli sconti applicati agli ordini
            if (!$schema->hasTable('pongho_shop_orders_order_discounts')) {
                $ordersOrderDiscountsTable = $schema->createTable('pongho_shop_orders_order_discounts');
                $ordersOrderDiscountsTable->addColumn('order_id', 'integer', ['unsigned' => true, 'notnull' => true]);
                $ordersOrderDiscountsTable->addColumn('discount_id', 'integer', ['unsigned' => true, 'notnull' => true]);
                $ordersOrderDiscountsTable->addColumn('name', 'string', ['length' => 255, 'default' => '']);
                $ordersOrderDiscountsTable->addColumn('value', 'decimal', ['precision' => 12, 'scale' => 4, 'default' => 0]);
                $ordersOrderDiscountsTable->addColumn('priority', 'integer', ['unsigned' => true, 'notnull' => false]);
                $ordersOrderDiscountsTable->addForeignKeyConstraint($ordersTable, ['order_id'], ['id']);
                $ordersOrderDiscountsTable->addForeignKeyConstraint($orderDiscountsTable, ['discount_id'], ['id']);
            }
        });

        /**
         * Sposto i dati nelle nuove tabelle
         */
        $sth = $this->connection->prepare('SELECT * FROM pongho_orders_discounts');
        $sth->execute();

        $discountConversionMap = [
            'shop_order_amount_discount'    => 'order_amount',
            'shop_shopping_points_discount' => 'shopping_points',
            'shop_coupon_discount'          => 'coupon_code',
        ];

        foreach ($sth as $row) {
            $handler = $row['handler_name'];
            if (isset($discountConversionMap[$handler])) {
                $row['handler_name'] = $discountConversionMap[$handler];
            }

            $this->connection->insert(
                'pongho_shop_order_discounts',
                $row,
                [
                    'id'           => \PDO::PARAM_INT,
                    'handler_name' => \PDO::PARAM_STR,
                    'code'         => \PDO::PARAM_STR,
                    'expire_on'    => \PDO::PARAM_STR,
                ]
            );
        }

        $sth = $this->connection->prepare('SELECT * FROM pongho_orders_discounts_conditions');
        $sth->execute();

        $conditionFieldName = $this->connection->quoteIdentifier('condition');

        foreach ($sth as $row) {
            $this->connection->insert(
                'pongho_shop_order_discounts_conditions',
                [
                    'id'                => $row['id'],
                    'discount_id'       => $row['discount_id'],
                    'value'             => $row['value'],
                    'value_type'        => $row['value_type'],
                    $conditionFieldName => $row['condition'],
                ],
                [
                    'id'                => \PDO::PARAM_INT,
                    'discount_id'       => \PDO::PARAM_INT,
                    'value'             => 'float',
                    'value_type'        => \PDO::PARAM_STR,
                    $conditionFieldName => 'float',
                ]
            );
        }

        $sth = $this->connection->prepare('SELECT id, discount_id, discount_name, discount_value FROM pongho_orders WHERE discount_id IS NOT NULL');
        $sth->execute();

        foreach ($sth as $row) {
            $this->connection->insert(
                'pongho_shop_orders_order_discounts',
                [
                    'order_id'    => $row['id'],
                    'discount_id' => $row['discount_id'],
                    'name'        => $row['discount_name'],
                    'value'       => $row['discount_value'],
                    'priority'    => 1,
                ],
                [
                    'order_id'    => \PDO::PARAM_INT,
                    'discount_id' => \PDO::PARAM_INT,
                    'name'        => \PDO::PARAM_STR,
                    'value'       => 'float',
                    'priority'    => \PDO::PARAM_INT,
                ]
            );
        }

        /**
         * Converto le opzioni alla nuova gestione sconti
         *
         * @var \Application\Core\Model\Site $site
         */
        $sth = $this->connection->prepare('SELECT id, settings FROM pongho_sites');
        $sth->execute();

        foreach ($sth as $site) {
            $options = unserialize($site['settings']);
            $oldValue = isset($options['order_discount_type']) ? $options['order_discount_type'] : '';
            $newValue = [];

            if ($oldValue) {
                $newValue[] = $oldValue;
            }

            unset($options['order_discount_type']);
            $options['order_discounts'] = $newValue;

            $this->connection->update(
                'pongho_sites',
                [
                    'settings' => serialize($options),
                ],
                [
                    'id' => $site['id'],
                ],
                [
                    'id'       => \PDO::PARAM_INT,
                    'settings' => \PDO::PARAM_STR,
                ]
            );
        }

        /**
         * Rimuovo le colonne inutilizzate
         */
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema) {

            // Rimuovo le colonne dalla tabella degli ordini
            $ordersTable = $schema->getTable('pongho_orders');
            $ordersTable->dropColumn('discount_id');
            $ordersTable->dropColumn('discount_name');
            $ordersTable->dropColumn('discount_value');

            $schema->dropTable('pongho_orders_discounts_conditions');
            $schema->dropTable('pongho_orders_discounts');

        });

        /**
         * Traduzioni
         */
        (new TranslationsHelper($this->connection))
            ->setCulture('it_IT')
            ->addTranslation('coupon_label_fixed', 'Buono sconto', 'showcase')
            ->addTranslation('coupon_label_percent', 'Buono sconto (%s)', 'showcase')
        ;
    }
}
