<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Application\Core\Installer\Helper\DatabaseSchemaHelper;
use Application\Core\Installer\Helper\TranslationsHelper;
use Doctrine\DBAL\Schema\Schema;
use Updates\BaseUpdate;

/**
 * Update191
 */
class Update191 extends BaseUpdate
{
    public function commit()
    {
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema) {

            $nodes_table = $schema->getTable('pongho_nodes');

            if (!$nodes_table->hasColumn('shopping_points')) {
                $nodes_table->addColumn('shopping_points', 'integer', array('unsigned' => true, 'default' => 0));
            }

            $sizes_table = $schema->getTable('pongho_nodes_sizes');

            if (!$sizes_table->hasColumn('shopping_points')) {
                $sizes_table->addColumn('shopping_points', 'integer', array('unsigned' => true, 'default' => 0));
            }

            $order_rows_table = $schema->getTable('pongho_orders_rows');

            if (!$order_rows_table->hasColumn('shopping_points')) {
                $order_rows_table->addColumn('shopping_points', 'integer', array('unsigned' => true, 'default' => 0));
            }
        });

        (new TranslationsHelper($this->connection))
            ->setCulture('it_IT')
            ->addTranslation(
                'shopping_points_cart_summary',
                'Finora hai accumulato <strong>%s</strong> punti. Non appena spedito e fatturato, questo ordine ti permetterà di guadagnare <strong>%s</strong> punti.',
                'showcase'
            )
            ->addTranslation(
                'shopping_points_row_cart_summary',
                'Questo prodotto ti fa guadagnare <strong>%s</strong> punti',
                'showcase'
            )
        ;
    }
}
