<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Application\Core\Model\Translation;
use Updates\BaseUpdate;

/**
 * Update160
 *
 * Traduzioni per la raccolta punti.
 */
class Update160 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        Translation::putTranslation(
            'shopping_points_checkout_error',
            'Hai inserito un numero di punti non valido. Ti ricordiamo che devi utilizzare almeno <strong>%s</strong> punti fino ad un massimo di <strong>%s</strong>.',
            'Showcase',
            'it_IT'
        );

        Translation::putTranslation(
            'shopping_points_checkout_label',
            'Oppure puoi utilizzare i tuoi punti oggi! Quanti ne vuoi utilizzare?',
            'Showcase',
            'it_IT'
        );

        Translation::putTranslation(
            'shopping_points_checkout_min_order_explain',
            'Per poter accumulare punti devi fare un ordine di almeno <strong>%s</strong>.',
            'Showcase',
            'it_IT'
        );

        Translation::putTranslation(
            'shopping_points_checkout_placeholder',
            'Minimo %d punti',
            'Showcase',
            'it_IT'
        );

        Translation::putTranslation(
            'shopping_points_checkout_submit',
            'Utilizza',
            'Showcase',
            'it_IT'
        );

        Translation::putTranslation(
            'shopping_points_checkout_summary',
            'Finora hai accumulato <strong>%s</strong> punti. Non appena spedito e fatturato, questo ordine ti permetterà di guadagnare <strong>%s</strong> punti.',
            'Showcase',
            'it_IT'
        );

        Translation::putTranslation(
            'shopping_points_customer_summary',
            'Hai accumulato <strong>%s</strong> punti. Con un minimo di %s punti puoi usufruire dello sconto di %s a punto.',
            'Showcase',
            'it_IT'
        );

        Translation::putTranslation(
            'shopping_points_discount',
            'Sconto punti (%s)',
            'Showcase',
            'it_IT'
        );

        Translation::putTranslation(
            'shopping_points_order_summary',
            'Complimenti! Con questo ordine hai guadagnato <strong>%s</strong> punti. Una volta fatturato, il tuo totale punti sarà di <strong>%s</strong>.',
            'Showcase',
            'it_IT'
        );
    }
}
