<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Application\Cms\Model\Node;
use Application\Cms\Model\Taxonomy;
use Application\Cms\Model\Term;
use Updates\BaseUpdate;

/**
 * Update124.
 *
 * Si assicura che tutti i tipi di nodo catalogo abbiano le tassonomie "category" e "brand".
 */
class Update124 extends BaseUpdate
{
    /**
     * @var array
     */
    private $it_language_id;

    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $node_type_select = 'SELECT ms.id, ms.module_id, m.node_type, ms.translations FROM pongho_modules_sites AS ms INNER JOIN pongho_modules AS m ON m.id = ms.module_id WHERE m.controller = ?';
        $node_type_params = array('Application\\Showcase\\Controller\\NodeController');

        $taxonomies_select = 'SELECT * FROM pongho_taxonomies WHERE module_site_id = ?';

        foreach ($this->connection->fetchAll($node_type_select, $node_type_params) as $node_type) {
            $taxonomies = array();

            foreach ($this->connection->fetchAll($taxonomies_select, array($node_type['id'])) as $taxonomy) {
                $taxonomies[$taxonomy['name']] = $taxonomy;
            }

            if (!isset($taxonomies['category'])) {
                $this->connection->insert(
                    'pongho_taxonomies',
                    array(
                        'name'             => 'category',
                        'module_site_id'   => $node_type['id'],
                        'mode'             => Taxonomy::MODE_HIERARCHY,
                        'is_required'      => false,
                        'show_in_nodelist' => true,
                        'terms_order'      => Term::MANUAL_ORDER_OPTION,
                        'nodes_order'      => Node::ORDER_BY_ID_ASC_OPTION,
                    )
                );
            }

            if (!isset($taxonomies['brand'])) {
                $this->connection->insert(
                    'pongho_taxonomies',
                    array(
                        'name'             => 'brand',
                        'module_site_id'   => $node_type['id'],
                        'mode'             => Taxonomy::MODE_NORMAL,
                        'is_required'      => false,
                        'show_in_nodelist' => true,
                        'terms_order'      => Term::ORDER_BY_TITLE_ASC_OPTION,
                        'nodes_order'      => Node::ORDER_BY_ID_ASC_OPTION,
                    )
                );
            }

            $this->addTranslations(
                $node_type,
                array(
                    'taxonomy_category'           => 'Categoria',
                    'taxonomy_category_plural'    => 'Categorie',
                    'taxonomy_category_add'       => 'Aggiungi categoria',
                    'taxonomy_category_edit'      => 'Modifica la categoria “%s“',
                    'taxonomy_category_add_first' => 'Aggiungi la prima categoria',
                    'permit_taxonomy_category'    => 'Può gestire le categorie',
                )
            );

            $this->addTranslations(
                $node_type,
                array(
                    'taxonomy_brand'           => 'Marca',
                    'taxonomy_brand_plural'    => 'Marche',
                    'taxonomy_brand_add'       => 'Aggiungi marca',
                    'taxonomy_brand_edit'      => 'Modifica la marca “%s“',
                    'taxonomy_brand_add_first' => 'Aggiungi la prima marca',
                    'permit_taxonomy_brand'    => 'Può gestire le marche',
                )
            );
        }
    }

    /**
     * @param array $node_type
     * @param array $translations
     */
    private function addTranslations(array $node_type, array $translations)
    {
        $nt_translations = $node_type['translations'] ? json_decode($node_type['translations'], true) : array();

        $it_language_id = $this->getItLanguageId();

        if (!isset($nt_translations[$it_language_id])) {
            $nt_translations[$it_language_id] = array();
        }

        $nt_translations[$it_language_id] = array_merge($nt_translations[$it_language_id], $translations);

        $this->connection->update(
            'pongho_modules_sites',
            array('translations' => json_encode($nt_translations)),
            array('id' => $node_type['id'])
        );
    }

    private function getItLanguageId()
    {
        if ($this->it_language_id === null) {
            $this->it_language_id = $this->connection->fetchColumn(
                'SELECT id FROM pongho_languages WHERE iso = ?',
                array('it')
            );
        }

        return $this->it_language_id;
    }
}
