<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Updates\BaseUpdate;

/**
 * Update121.
 *
 * Corregge il valore delle disponibilità dei prodotti.
 */
class Update121 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $query = "SELECT n.id, n.availabilities, SUM(s.availabilities) AS sizes_availabilities
FROM pongho_nodes AS n
  INNER JOIN pongho_modules_sites AS ms ON ms.id = n.module_site_id
  INNER JOIN pongho_modules AS m ON m.id = ms.module_id
  LEFT JOIN pongho_nodes_sizes AS s ON s.node_id = n.id
WHERE m.controller = 'Application\\\\Showcase\\\\Controller\\\\NodeController'
GROUP BY n.id
HAVING n.availabilities <> SUM(s.availabilities)";

        foreach ($this->connection->fetchAll($query) as $product) {
            $this->connection->update(
                'pongho_nodes',
                array('availabilities' => $product['sizes_availabilities']),
                array('id' => $product['id']),
                array('availabilities' => \PDO::PARAM_INT, 'id' => \PDO::PARAM_INT)
            );
        }
    }
}
