<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Application\Core\Model\Permit;
use Application\Core\Model\PermitRole;
use Updates\BaseUpdate;

/**
 * Update117.
 *
 * Aggiorna i permessi per le statistiche.
 */
class Update117 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $permits = array();

        //
        // Aggiungo i nuovi permessi (mi assicuro esista anche 'shop.stats')
        //

        foreach (array('shop.stats', 'shop.stats.sold', 'shop.stats.ordered') as $key) {
            $permit = Permit::findByKey($key);

            if (!$permit) {
                $permit = Permit::create(
                    array(
                        'key' => $key,
                        'is_enabled' => true,
                    )
                );
            }

            $permits[$key] = $permit;
        }


        //
        // Assegno il permesso 'shop.stats.sold' a tutti i ruoli che hanno già il permesso 'shop.stats'
        //

        $options = array(
            'conditions' => array('permit_id = ?', $permits['shop.stats']->id),
        );

        /** @var PermitRole $pr */
        foreach (PermitRole::all($options) as $pr) {
            PermitRole::create(
                array(
                    'permit_id' => $permits['shop.stats.sold']->id,
                    'role_id'   => $pr->role_id,
                )
            );
        }
    }
}
