<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

/**
 * Update108.
 *
 * Aggiunge le nuove colonne per tener traccia dei prodotti legati ai carrelli, ai pagamenti e agli ordini da evadere.
 */
class Update108 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $nodes_table = $schema->getTable('pongho_nodes');

        $nodes_table->addColumn('availabilities', 'integer', array('unsigned' => true, 'default' => 0));
        $nodes_table->addColumn('bound_in_cart', 'integer', array('unsigned' => true, 'default' => 0));
        $nodes_table->addColumn('bound_in_cart_updated_at', 'datetime', array('notnull' => false));
        $nodes_table->addColumn('bound_in_payment', 'integer', array('unsigned' => true, 'default' => 0));
        $nodes_table->addColumn('bound_in_payment_updated_at', 'datetime', array('notnull' => false));
        $nodes_table->addColumn('bound_in_order', 'integer', array('unsigned' => true, 'default' => 0));

        $sizes_table = $schema->getTable('pongho_nodes_sizes');

        $sizes_table->addColumn('bound_in_cart', 'integer', array('unsigned' => true, 'default' => 0));
        $sizes_table->addColumn('bound_in_cart_updated_at', 'datetime', array('notnull' => false));
        $sizes_table->addColumn('bound_in_payment', 'integer', array('unsigned' => true, 'default' => 0));
        $sizes_table->addColumn('bound_in_payment_updated_at', 'datetime', array('notnull' => false));
        $sizes_table->addColumn('bound_in_order', 'integer', array('unsigned' => true, 'default' => 0));
    }
}
