<?php
/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var string                                       $add_url
 * @var string                                       $mass_action_url
 * @var string                                       $mass_action_buttons
 */
?><div class="section">

	<h2><?php echo $translator->trans('Sizes'); ?></h2>

	<div class="panel">
		<div class="btn"><a href="<?php echo $add_url; ?>" class="primary"><?php echo $translator->trans('Add size'); ?></a></div>

		<form action="<?php echo $mass_action_url; ?>" method="post" class="clr">
			<table class="pongho-table">
				<thead>
					<tr>
						<th class="ckb"><input type="checkbox" /></th>
						<th class="main"><?php echo $translator->trans('Size'); ?></th>
					</tr>
				</thead>
				<tfoot>
					<tr>
						<th class="ckb"><input type="checkbox" /></th>
						<th class="main"><?php echo $translator->trans('Size'); ?></th>
					</tr>
				</tfoot>
				<tbody>
					<?php if (empty($rows)): ?>
						<tr>
							<td colspan="2" class="empty"><a href="<?php echo $add_url; ?>"><?php echo $translator->trans('Add the first size'); ?></a></td>
						</tr>
					<?php else: foreach ($rows as $row): ?>
						<tr>
							<td class="ckb"><input type="checkbox" name="ids[<?php echo $row->id; ?>]" /></td>
							<td class="main">
								<strong><?php echo $row->title; ?></strong>
								<div class="actions"><span><?php echo $row->actions; ?></span></div>
							</td>
						</tr>
					<?php endforeach; endif; ?>
				</tbody>
			</table>

			<div class="btn">
				<?php echo $mass_action_buttons; ?>
			</div>
		</form>

	</div><!-- .panel -->

</div><!-- .section -->
