<?php
/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var \Application\Core\User                       $user
 * @var string                                       $add_url
 * @var string                                       $mass_action_url
 * @var string                                       $mass_action_buttons
 */
?><div class="section">

	<h2><?php echo $translator->trans('Shipping methods'); ?></h2>

	<div class="panel">
		<?php if ($user->hasPermit('shop.admin.shippings.add')): ?>
			<div class="btn"><a href="<?php echo $add_url; ?>" class="primary"><?php echo $translator->trans('Add shipping method'); ?></a></div>
		<?php endif; ?>

		<form action="<?php echo $mass_action_url; ?>" method="post" class="clr">
			<table class="pongho-table">
				<thead>
					<tr>
						<th class="ckb"><input type="checkbox" /></th>
						<th class="main"><?php echo $translator->trans('Shipping'); ?></th>
					</tr>
				</thead>
				<tfoot>
					<tr>
						<th class="ckb"><input type="checkbox" /></th>
						<th class="main"><?php echo $translator->trans('Shipping'); ?></th>
					</tr>
				</tfoot>
				<tbody>
					<?php foreach ($rows as $row): ?>
						<tr>
							<td class="ckb"><input type="checkbox" name="ids[<?php echo $row->id; ?>]" /></td>
							<td class="main">
								<strong><?php echo $row->name; ?></strong>
								<div class="actions"><span><?php echo $row->actions; ?></span></div>
							</td>
						</tr>
					<?php endforeach; ?>
				</tbody>
			</table>

			<div class="btn">
				<?php echo $mass_action_buttons; ?>
			</div>
		</form>

	</div><!-- .panel -->

</div><!-- .section -->
