<?php
/**
 * @var \Application\Core\I18n\Translation\Translator  $translator
 * @var string                                        $action_form
 * @var string                                        $title
 * @var \Application\Showcase\Model\ShippingCondition $conditions
 */
?><form action="<?php echo $action_form; ?>" method="post" class="section">

	<h2><?php echo $title; ?></h2>

	<?php include 'messages.php' ?>

	<fieldset class="panel">
		<dl class="extend">
			<dt><label for="name"><?php echo $translator->trans('Name'); ?></label></dt>
			<dd><?php echo $field_name; ?></dd>
		</dl>
		<dl class="extend">
			<dt><label for="description"><?php echo $translator->trans('Description'); ?></label></dt>
			<dd><?php echo $field_description; ?></dd>
		</dl>
	</fieldset>

	<fieldset class="panel">
		<h3><?php echo $translator->trans('Conditions'); ?></h3>

		<table class="pongho-table">
			<thead>
				<tr>
					<th style="width: 200px;" class="small"><?php echo $translator->trans('Min price'); ?></th>
					<th colspan="2" style="width: auto;" class="small"><?php echo $translator->trans('Cost'); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ($conditions as $condition): ?>
					<tr>
						<td style="width: 200px;" class="small"><input type="text" name="conditions[<?php echo $condition->id; ?>][condition_by_price]" value="<?php echo format_price($condition->condition_by_price, false); ?>" class="input_text"> <span class="unit">€</span></td>
						<td style="width: 200px;" class="small"><input type="text" name="conditions[<?php echo $condition->id; ?>][cost]" value="<?php echo format_price($condition->cost, false); ?>" class="input_text"> <span class="unit">€</span></td>
						<td style="width: auto;"><label><input type="checkbox" name="conditions[<?php echo $condition->id; ?>][is_deletable]"> <?php echo $translator->trans('Delete'); ?></label></td>
					</tr>
				<?php endforeach; ?>

				<tr class="blankRecord">
					<td style="width: 200px;" class="small"><input type="text" name="conditions[new][condition_by_price]" class="input_text"> <span class="unit">€</span></td>
					<td style="width: 200px;" class="small"><input type="text" name="conditions[new][cost]" class="input_text"> <span class="unit">€</span></td>
					<td style="width: auto;"><label><input type="checkbox" name="conditions[new][is_deletable]"> <?php echo $translator->trans('Delete'); ?></label></td>
				</tr>
			</tbody>
		</table>

		<div class="btn"><input type="button" value="<?php echo $translator->trans('Add condition'); ?>" class="addRecord" /></div>
	</fieldset>

	<fieldset class="btn">
		<input type="submit" name="submit" value="<?php echo $translator->trans('Save'); ?>" class="primary" />
	</fieldset>

</form><!-- .section -->
