<?php

/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var \Application\Showcase\Model\Order             $order
 * @var \Application\Core\Localization                $lang
 * @var \Application\Core\Model\Account               $customer
 * @var \Application\Core\Model\Site                  $site
 * @var \Application\Core\Utilities\Pagination        $pagination
 * @var \Pongho\Menu\Menu                             $filter_status
 * @var string                                        $filter
 * @var string                                        $list_orders_url
 * @var string                                        $mass_action_url
 * @var string                                        $query
 * @var string                                        $search_url
 * @var string                                        $export_url
 */

switch ($_SERVER['HTTP_HOST']) {
    case 'hdc.dev':
    case 'www.hdc.dev':
    case 'areariservata.holidaydream.club':
    	$_customer = 'hdc';
        break;

    default:
        $_customer = null;
        break;
}

?>
<div class="section">

    <h2><?php echo $translator->trans('Orders'); ?></h2>

    <div class="panel">
        <div class="header-actions">
            <div class="bckl">
                <?php if ($customer): ?>
                    <h4 class="filter-customer"><?php echo $customer->name(); ?> (<a href="<?php echo $list_orders_url; ?>"><?php echo $translator->trans('Cancel'); ?></a>)</h4>
                <?php endif; ?>

                <div class="filter-status">
                    <ul><?php echo $filter_status; ?></ul>
                </div>
            </div>

            <div class="bckr">
                <form method="get" action="<?php echo $search_url ?>" id="search-form" class="pongho-form" style="float: left; margin-right: 8px;">
                    <input type="hidden" name="site" value="<?php echo $site->id; ?>" />
                    <input type="hidden" name="language" value="<?php echo $site->default_language_id; ?>" />
                    <input type="hidden" name="filter" value="<?php echo $filter; ?>" />
                    <input type="text" name="q" id="search-query" class="input_text" value="<?php echo $query; ?>" placeholder="<?php echo $translator->trans('Search by ID'); ?>">
                    <input type="submit" id="search-button" class="pongho-button" value="<?php echo $translator->trans('Search order'); ?>" />
                </form>

				<?php if ($site->getOption('enable_orders_export')): ?>
					<a href="<?= $export_url; ?>" class="pongho-button"><?= $translator->trans('Export'); ?></a>
				<?php endif; ?>
            </div>
        </div>
    </div>

	<div id="list">
        <form action="<?php echo $mass_action_url; ?>" method="post" class="pongho-form">
			<div class="panel">
				<table class="pongho-table">
					<thead>
					<tr>
						<th class="main"><?php echo $translator->trans('Order'); ?></th>
						<th><?php echo $translator->trans('Customer'); ?></th>
                        <?php if ($_customer === 'hdc'): ?><th>Codice HDC</th><?php endif; ?>
						<th><?php echo $translator->trans('Payment'); ?></th>
						<th><?php echo $translator->trans('Shipping'); ?></th>
						<th><?php echo $translator->trans('Status'); ?></th>
						<th class="date"><?php echo $translator->trans('Ordered at'); ?></th>
						<th class="date"><?php echo $translator->trans('Paid at'); ?></th>
						<th class="date"><?php echo $translator->trans('Processed at'); ?></th>
						<th><?php echo $translator->trans('Total'); ?></th>
					</tr>
					</thead>
					<tfoot>
					<tr>
						<th class="main"><?php echo $translator->trans('Order'); ?></th>
						<th><?php echo $translator->trans('Customer'); ?></th>
                        <?php if ($_customer === 'hdc'): ?><th>Codice HDC</th><?php endif; ?>
						<th><?php echo $translator->trans('Payment'); ?></th>
						<th><?php echo $translator->trans('Shipping'); ?></th>
						<th><?php echo $translator->trans('Status'); ?></th>
						<th class="date"><?php echo $translator->trans('Ordered at'); ?></th>
						<th class="date"><?php echo $translator->trans('Paid at'); ?></th>
						<th class="date"><?php echo $translator->trans('Processed at'); ?></th>
						<th><?php echo $translator->trans('Total'); ?></th>
					</tr>
					</tfoot>
					<tbody>
						<?php if (empty($orders)): ?>
						<tr>
							<td colspan="8" class="empty"><?php echo $translator->trans('The search did not return any result'); ?></td>
						</tr>
						<?php else: foreach ($orders as $order): ?>
						<tr>
							<td class="main">
								<strong><?php echo $order->id; ?></strong>
								<div class="actions"><span><?php echo $order->actions; ?></span></div>
							</td>
							<td>
								<a href="<?php echo $order->customer_orders_url; ?>"><?php echo $order->getCustomerName(); ?></a><br>
								<?php echo $order->getCustomerEmail(); ?>
							</td>
                            <?php if ($_customer === 'hdc'): ?><td><?= $order->customer->custom_hdc_code; ?></td><?php endif; ?>
							<td><?php echo $order->payment->name; ?></td>
							<td><?php echo $order->shipping->name; ?></td>
							<td><?php echo $lang->get('order_status_' . $order->status); ?></td>
							<td><?php echo $order->ordered_at->format('d-m-Y'); ?></td>
							<td><?php echo $order->paid_at ? $order->paid_at->format('d-m-Y') : '-'; ?></td>
							<td><?php echo $order->processed_at ? $order->processed_at->format('d-m-Y') : '-'; ?></td>
							<td><?php echo $order->formatTotal(); ?></td>
						</tr>
						<?php endforeach; endif; ?>
					</tbody>
				</table>
			</div>

			<div class="footer-actions">
            	<div class="pagination"><?php echo $pagination; ?></div>
			</div>
        </form>

    </div><!-- .panel -->

</div><!-- .section -->
