<?php

/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var \Application\Showcase\Model\Size[]           $sizes
 * @var bool                                         $availabilities_enabled
 * @var bool                                         $gs_enabled
 * @var bool                                         $shopping_point_on_single_product
 */

$colspan = 1 + ($availabilities_enabled ? 1 : 0) + ($shopping_point_on_single_product ? 1 : 0) + ($gs_enabled ? 3 : 0);

?>
<div class="repeater-container">
    <div class="actions">
        <input type="button" name="add" value="<?php echo $translator->trans('Add size') ?>" class="repeater-add-row pongho-button">
    </div>

    <table class="pongho-table">
        <thead>
            <tr>
                <th style="width: 400px;"><?php echo $translator->trans('Size'); ?></th>
                <th style="width: auto;"><?php echo $translator->trans('Price'); ?></th>
                <?php if ($availabilities_enabled): ?>
                    <th style="width: auto;"><?php echo $translator->trans('Availabilities'); ?></th>
                <?php endif; ?>
                <?php if ($shopping_point_on_single_product): ?>
                    <th style="width: auto;" title="<?php echo $translator->trans('Earnable points with this product'); ?>">
                        <?php echo $translator->trans('Points'); ?>
                    </th>
                <?php endif; ?>
                <?php if ($gs_enabled): ?>
                    <th style="width: 160px;" title="Global Trade Item Number">GTIN</th>
                    <th style="width: 160px;" title="Manufacturer Part Number">MPN</th>
                    <th style="width: 90px;" title="<?php echo $translator->trans('Include the size in the Google Shopping Feed'); ?>">Google Shopping</th>
                <?php endif; ?>
            </tr>
            <tr>
                <td style="width: 400px;" class="r"><?php echo $translator->trans('Assign the same value'); ?></td>
                <td style="width: auto;"<?php echo $colspan > 1 ? " colspan=\"$colspan\"": '' ?>>
                    <input type="text" class="input_text smaller col-value" data-type="number" data-col="price">
                    <input type="button" value="<?php echo $translator->trans('Submit'); ?>" class="col-value-setter pongho-button">
                </td>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th style="width: 400px;"><?php echo $translator->trans('Size'); ?></th>
                <th style="width: auto;"><?php echo $translator->trans('Price'); ?></th>
                <?php if ($availabilities_enabled): ?>
                    <th style="width: auto;"><?php echo $translator->trans('Availabilities'); ?></th>
                <?php endif; ?>
                <?php if ($shopping_point_on_single_product): ?>
                    <th style="width: auto;" title="<?php echo $translator->trans('Earnable points with this product'); ?>">
                        <?php echo $translator->trans('Points'); ?>
                    </th>
                <?php endif; ?>
                <?php if ($gs_enabled): ?>
                    <th style="width: 160px;" title="Global Trade Item Number">GTIN</th>
                    <th style="width: 160px;" title="Manufacturer Part Number">MPN</th>
                    <th style="width: 90px;" title="<?php echo $translator->trans('Include the size in the Google Shopping Feed'); ?>">Google Shopping</th>
                <?php endif; ?>
            </tr>
        </tfoot>
        <tbody class="repeater">
            <tr class="repeater-blank-row" id="size-name-new">
                <td style="width: 400px;"><input type="text" name="sizes[new][name]" class="input_text" /></td>
                <td style="width: auto;"><input type="text" name="sizes[new][price]" class="input_text smaller price"></td>
                <?php if ($availabilities_enabled): ?>
                    <td style="width: auto;"><input type="number" name="sizes[new][availabilities]" value="" class="input_text smaller"></td>
                <?php endif; ?>
                <?php if ($shopping_point_on_single_product): ?>
                    <td style="width: auto;"><input type="number" name="sizes[new][shopping_points]" value="" class="input_text smaller"></td>
                <?php endif; ?>
                <?php if ($gs_enabled): ?>
                    <td style="width: 160px;">
                        <input type="text" name="sizes[new][gtin]" maxlength="20" value="" class="input_text small">
                    </td>
                    <td style="width: 160px;">
                        <input type="text" name="sizes[new][mpn]" maxlength="20" value="" class="input_text small">
                    </td>
                    <td style="text-align: center; width: 90px;">
                        <input type="checkbox" name="sizes[new][gs_enabled]">
                    </td>
                <?php endif; ?>
            </tr>

            <?php foreach ( $sizes as $size ): ?>
                <tr class="repeater-row" id="size-name-<?php echo $size->size_name_id; ?>">
                    <td style="width: 400px;"><input type="text" name="sizes[<?php echo $size->size_name_id; ?>][name]" value="<?php echo $size->name(); ?>" class="input_text"></td>
                    <td style="width: auto;"><input type="text" name="sizes[<?php echo $size->size_name_id; ?>][price]" value="<?php echo format_price($size->price, false); ?>" class="input_text smaller price"></td>
                    <?php if ($availabilities_enabled): ?>
                        <td style="width: auto;">
                            <input type="number" name="sizes[<?php echo $size->size_name_id; ?>][availabilities]" value="<?php echo $size->availabilities; ?>" class="input_text smaller">
                            <?php if ($size->bound): ?>
                                <span><?php echo $translator->trans('<b>%number%</b> of which to be processed', array('%number%' => $size->bound)); ?></span>
                            <?php endif; ?>
                        </td>
                    <?php endif; ?>
                    <?php if ($shopping_point_on_single_product): ?>
                        <td style="width: auto;"><input type="number" name="sizes[<?php echo $size->size_name_id; ?>][shopping_points]" value="<?php echo $size->shopping_points; ?>" class="input_text smaller"></td>
                    <?php endif; ?>
                    <?php if ($gs_enabled): ?>
                        <td style="width: 160px;">
                            <input type="text" name="sizes[<?php echo $size->size_name_id; ?>][gtin]" maxlength="20" value="<?php echo $size->gtin; ?>" class="input_text small">
                        </td>
                        <td style="width: 160px;">
                            <input type="text" name="sizes[<?php echo $size->size_name_id; ?>][mpn]" maxlength="20" value="<?php echo $size->mpn; ?>" class="input_text small">
                        </td>
                        <td style="text-align: center; width: 90px;">
                            <input type="checkbox" name="sizes[<?php echo $size->size_name_id; ?>][gs_enabled]"<?php echo $size->gs_enabled ? ' checked' : '' ?>>
                        </td>
                    <?php endif; ?>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
