<?php

/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var \Application\Showcase\Model\Size[]           $sizes
 * @var bool                                         $availabilities_enabled
 * @var bool                                         $gs_enabled
 * @var bool                                         $shopping_point_on_single_product
 */

$colspan = 1 + ($availabilities_enabled ? 1 : 0) + ($shopping_point_on_single_product ? 1 : 0) + ($gs_enabled ? 3 : 0);

if (empty($sizes)): ?>
	<p class="empty"><?php echo $translator->trans('Select the size type or <a id="select-custom-size-type">add a custom size</a>'); ?></p>
<?php else: ?>
	<table class="pongho-table">
		<thead>
			<tr>
                <th style="width: 400px;"><?php echo $translator->trans('Size'); ?></th>
                <th style="width: auto;"><?php echo $translator->trans('Price'); ?></th>
                <?php if ($availabilities_enabled): ?>
                    <th style="width: auto;"><?php echo $translator->trans('Availabilities'); ?></th>
                <?php endif; ?>
                <?php if ($shopping_point_on_single_product): ?>
                    <th style="width: auto;" title="<?php echo $translator->trans('Earnable points with this product'); ?>">
                        <?php echo $translator->trans('Points'); ?>
                    </th>
                <?php endif; ?>
                <?php if ($gs_enabled): ?>
                    <th style="width: 160px;" title="Global Trade Item Number">GTIN</th>
                    <th style="width: 160px;" title="Manufacturer Part Number">MPN</th>
                    <th style="width: 90px;" title="<?php echo $translator->trans('Include the size in the Google Shopping Feed'); ?>">Google Shopping</th>
                <?php endif; ?>
			</tr>
            <tr>
                <td style="width: 400px;" class="r"><?php echo $translator->trans('Assign the same value'); ?></td>
                <td style="width: auto;"<?php echo $colspan > 1 ? " colspan=\"$colspan\"": '' ?>>
                    <input type="text" class="input_text smaller col-value" data-type="number" data-col="price">
                    <input type="button" value="<?php echo $translator->trans('Submit'); ?>" class="col-value-setter pongho-button">
                </td>
            </tr>
		</thead>
		<tfoot>
            <tr>
                <th style="width: 400px;"><?php echo $translator->trans('Size'); ?></th>
                <th style="width: auto;"><?php echo $translator->trans('Price'); ?></th>
                <?php if ($availabilities_enabled): ?>
                    <th style="width: auto;"><?php echo $translator->trans('Availabilities'); ?></th>
                <?php endif; ?>
                <?php if ($shopping_point_on_single_product): ?>
                    <th style="width: auto;" title="<?php echo $translator->trans('Earnable points with this product'); ?>">
                        <?php echo $translator->trans('Points'); ?>
                    </th>
                <?php endif; ?>
                <?php if ($gs_enabled): ?>
                    <th style="width: 160px;" title="Global Trade Item Number">GTIN</th>
                    <th style="width: 160px;" title="Manufacturer Part Number">MPN</th>
                    <th style="width: 90px;" title="<?php echo $translator->trans('Include the size in the Google Shopping Feed'); ?>">Google Shopping</th>
                <?php endif; ?>
            </tr>
		</tfoot>
		<tbody>
            <?php foreach ($sizes as $size): ?>
                <tr>
                    <td style="width: 400px;"><?php echo $size->name(); ?></td>
                    <td style="width: auto;"><input type="text" name="sizes[<?php echo $size->size_name_id; ?>][price]" value="<?php echo format_price($size->price, false); ?>" class="input_text smaller price"></td>
                    <?php if ($availabilities_enabled): ?>
                        <td style="width: auto;">
                            <input type="number" name="sizes[<?php echo $size->size_name_id; ?>][availabilities]" value="<?php echo $size->availabilities; ?>" class="input_text smaller">
                            <?php if ($size->bound_in_order): ?>
                                <span><?php echo $translator->trans('<b>%number%</b> of which to be processed', array('%number%' => $size->bound_in_order)); ?></span>
                            <?php endif; ?>
                        </td>
                    <?php endif; ?>
                    <?php if ($shopping_point_on_single_product): ?>
                        <td style="width: auto;"><input type="number" name="sizes[<?php echo $size->size_name_id; ?>][shopping_points]" value="<?php echo $size->shopping_points; ?>" class="input_text smaller"></td>
                    <?php endif; ?>
                    <?php if ($gs_enabled): ?>
                        <td style="width: 160px;">
                            <input type="text" name="sizes[<?php echo $size->size_name_id; ?>][gtin]" value="<?php echo $size->gtin; ?>" class="input_text small">
                        </td>
                        <td style="width: 160px;">
                            <input type="text" name="sizes[<?php echo $size->size_name_id; ?>][mpn]" value="<?php echo $size->mpn; ?>" class="input_text small">
                        </td>
                        <td style="text-align: center; width: 90px;">
                            <input type="checkbox" name="sizes[<?php echo $size->size_name_id; ?>][gs_enabled]"<?php echo $size->gs_enabled ? ' checked' : '' ?>>
                        </td>
                    <?php endif; ?>
                </tr>
			<?php endforeach; ?>
		</tbody>
	</table>

<?php endif; ?>
