<?php

/**
 * @var \Application\Showcase\Model\OrderDiscount     $discount
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var string                                        $content_url
 * @var string                                        $send_url
 */

?>
<style>
    .email-preview {
        display: flex;
        flex-direction: column;
        height: 100%;
    }

    .email-preview__headers, .email-preview__body, .email-preview__actions {
        width: 100%;
    }

    .email-preview__header {
        border-bottom: 1px solid #EEE;
        line-height: 32px;
        overflow: hidden;
    }

    .email-preview__header:last-child {
        border-bottom: 0 none;
    }

    .email-preview__header__label {
        float: left;
        text-align: right;
        width: 100px;
    }

    .email-preview__header__value {
        float: left;
        font-weight: bold;
        margin-left: 10px;
    }

    .email-preview__body {
        border: 1px solid #CCC;
        box-sizing: border-box;
        height: 100%;
    }

    .email-preview__actions {
        box-sizing: border-box;
        padding: 8px 4px 4px;
    }

    .email-preview__action-message {
        line-height: 17px;
        padding: 5px 0 4px;
        display: inline-block;
    }
</style>

<div class="email-preview">
    <div class="email-preview__headers">
        <dl class="email-preview__header">
            <dt class="email-preview__header__label">From:</dt>
            <dd class="email-preview__header__value">
                <?= $discount->getEmailSenderName(); ?> &lt;<?= $discount->getEmailSenderEmail(); ?>&gt;
            </dd>
        </dl>
        <dl class="email-preview__header">
            <dt class="email-preview__header__label">Subject:</dt>
            <dd class="email-preview__header__value"><?= $discount->getEmailSubject(); ?></dd>
        </dl>
    </div>

    <iframe class="email-preview__body" src="<?= $content_url; ?>"></iframe>

    <footer class="email-preview__actions">
        <a href="<?= $send_url; ?>" class="pongho-button btn-primary" id="js-send-button">Send</a>

        <?php if ($discount->isEmailSent()): ?>
            <span class="email-preview__action-message">
                <?= $translator->trans('The notification has been sent.') ?>
            </span>
        <?php endif; ?>
    </footer>
</div>

<script>
    (function ($) {
        "use strict";

        var button = $('#js-send-button');

        button.on('click', function (e) {
            e.preventDefault();

            button.addClass('busy');
            button.closest('.email-preview__actions').find('.email-preview__action-message').remove();

            $.post(button.attr('href'), function (response) {
                button.after(
                    $('<span />').addClass('email-preview__action-message').text(response.message)
                );

                button.removeClass('busy');
            });
        });
    }(jQuery));
</script>
