<?php

/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var \Pongho\Form\Field\TextareaField              $field
 * @var \Application\Showcase\Model\OrderDiscount     $discount
 * @var string                                        $preview_url
 */

?>
<div class="control-group">
    <div class="control-label">
        <label for="<?= $field->getId(); ?>"><?= $field->getLabel(); ?></label>
        <div style="margin-top: 50px;">
            <h3><?= $translator->trans('Message codes'); ?></h3>
            <p><?= $translator->trans('You can use the codes below to insert some variables on the message.'); ?></p>
            <dl class="js-wysiwyg-code" data-form="#field-coupon-email_body" data-code="%NAME%" style="margin-bottom: 8px; cursor: pointer;">
                <dt style="font-weight: bold;">%NAME%</dt>
                <dd><?= $translator->trans('Inserts the name of the user who will be receive the notification.'); ?></dd>
            </dl>
            <dl class="js-wysiwyg-code" data-form="#field-coupon-email_body" data-code="%EMAIL%" style="margin-bottom: 8px; cursor: pointer;">
                <dt style="font-weight: bold;">%EMAIL%</dt>
                <dd><?= $translator->trans('Inserts the email address of the user who will be receive the notification.'); ?></dd>
            </dl>
            <dl class="js-wysiwyg-code" data-form="#field-coupon-email_body" data-code="%COUPON_CODE%" style="margin-bottom: 8px; cursor: pointer;">
                <dt style="font-weight: bold;">%COUPON_CODE%</dt>
                <dd><?= $translator->trans('Inserts the coupon code.'); ?></dd>
            </dl>
        </div>
        <div style="margin-top: 50px;">
            <h3><?= $translator->trans('Send notifications'); ?></h3>
            <?php if (!$discount->isReadyToSendNotification()): ?>
                <p><?= $translator->trans('Before send the notification, you must populate the email fields.'); ?></p>
            <?php else: ?>
                <p><?= $translator->trans('Save the form before send the notification.'); ?></p>
                <p><a href="<?= $preview_url; ?>" class="pongho-button" id="button-coupon-preview"><?= $translator->trans('Preview'); ?></a></p>
            <?php endif; ?>
        </div>
    </div>
    <div class="controls">
        <?= $field->getTag(); ?>
    </div>
</div>
