<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Payment\Unicredit;

/**
 * Raccolta di utilities per la gestione del pagamento con Unicredit.
 */
class Utilities
{
    /**
     * Formatta il prezzo secondo le specifiche di Unicredit.
     *
     * @param float $price Il prezzo da formattare.
     * @return string Il prezzo formattato.
     */
    public static function formatPrice($price)
    {
        return round($price * 100);
    }
}
