<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Payment\Unicredit;

/**
 * Classe per il calcolo del MAC (Message Code Authentication).
 */
class Mac
{
    /**
     * Ordine da utilizzare per i parametri.
     *
     * @var array
     */
    protected static $PARAMETERS_ORDER = array(
        'numeroCommerciante',
        'userID',
        'password',
        'numeroOrdine',
        'totaleOrdine',
        'valuta',
        'flagDeposito',
        'urlOk',
        'urlKo',
        'tipoRispostaApv',
        'flagRiciclaOrdine',
        'stabilimento'
    );

    /**
     * Restituisce il MAC in base ai parametri passati.
     *
     * @param array  $parameters    Parametri.
     * @param string $secret_string Stringa segreta di sicurezza per il controllo del MAC.
     * @return string
     */
    public static function get(array $parameters, $secret_string)
    {
        $args = array();
        foreach ($parameters as $name => $value) {
            $args[] = $name . '=' . $value;
        }

        return self::calculate(md5(implode('&', $args) . '&' . $secret_string));
    }

    /**
     * Controlla la validità della chiamata.
     *
     * @param string $query         Query dell’indirizzo della richiesta.
     * @param string $secret_string Stringa segreta di sicurezza per il controllo del MAC.
     * @return bool Resituisce `true` se il MAC viene confermato, altrimenti `false`.
     */
    public static function validate($query, $secret_string)
    {
        if (($pos = strpos($query, '&mac=')) === false) {
            return false;
        }

        return self::calculate(md5(substr($query, 0, $pos) . '&' . $secret_string)) === substr($query, $pos + 5, 24);
    }

    /**
     * Calcola il MAC.
     *
     * @param string $MAC
     * @return string
     */
    protected static function calculate($MAC)
    {
        $MACtemp = '';
        $length = strlen($MAC);
        for ($i = 0; $i < $length; $i += 2) {
            $MACtemp .= chr(hexdec(substr($MAC, $i, 2)));
        }

        return base64_encode($MACtemp);
    }
}
