<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Payment;

use Pongho\Http\Response;

/**
 * PaymentResponse.
 */
class PaymentResponse
{
    /**
     * @var Response
     */
    protected $httpResponse;

    /**
     * @param Response $httpResponse
     */
    public function __construct(Response $httpResponse = null)
    {
        $this->httpResponse = $httpResponse;
    }

    /**
     * @return Response
     */
    public function getHttpResponse()
    {
        return $this->httpResponse;
    }

    /**
     * @param Response $response
     * @return $this
     */
    public function setHttpResponse(Response $response)
    {
        $this->httpResponse = $response;

        return $this;
    }
}
