<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Payment\PagOnline\Exception;

/**
 * InitException
 */
class InitException extends \Exception
{
    /**
     * @var \IgfsCgInit
     */
    protected $init;

    /**
     * VerifyException constructor.
     *
     * @param \IgfsCgInit $verify
     */
    public function __construct(\IgfsCgInit $verify)
    {
        $this->init = $verify;

        parent::__construct(sprintf('[%s] %s', $verify->rc, $verify->errorDesc));
    }

    /**
     * @return \IgfsCgInit
     */
    public function getInit()
    {
        return $this->init;
    }
}
