<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Payment;

use Application\Showcase\Model\Order;

/**
 * Base per i listener.
 */
abstract class BaseListener implements ListenerInterface
{
    /**
     * Modello dell’ordine.
     *
     * @var Order
     */
    protected $order;

    /**
     * Indica se è attivo il debug per l’ambiente di testing.
     *
     * @var bool
     */
    protected $is_debug = false;

    /**
     * @param Order $order    L’ordine da elaborare.
     * @param bool  $is_debug Indica se è attiva la modalità di debug.
     */
    public function __construct(Order $order, $is_debug = false)
    {
        $this->order = $order;
        $this->is_debug = (bool) $is_debug;
    }

    /**
     * Imposta l’ordine.
     *
     * @param \Application\Showcase\Model\Order $order L’ordine da elaborare.
     * @return $this
     */
    public function setOrder(Order $order)
    {
        $this->order = $order;

        return $this;
    }

    /**
     * Restituisce l’ordine.
     *
     * @return Order
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * Imposta la modalità di debug.
     *
     * @param bool $is_debug
     * @return $this
     */
    public function setDebug($is_debug)
    {
        $this->is_debug = (bool) $is_debug;

        return $this;
    }

    /**
     * Indica se è attiva la modalità di debug.
     *
     * @return bool
     */
    public function isDebug()
    {
        return $this->is_debug;
    }
}
