<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Model;

use ActiveRecord\Base;

/**
 * OrderOrderDiscount
 *
 * @property int           $order_id
 * @property int           $discount_id
 * @property string        $name
 * @property float         $value
 * @property int           $priority
 * @property Order         $order
 * @property OrderDiscount $discount
 */
class OrderOrderDiscount extends Base
{
    /**
     * Nome della tabella.
     *
     * @var string
     */
    public static $table_name = 'shop_orders_order_discounts';

    /**
     * Chiave primaria.
     *
     * @var array
     */
    public static $primary_key = ['order_id', 'discount_id'];

    /**
     * Relazioni 'belongs_to'.
     *
     * @var array
     */
    public static $belongs_to = [
        ['order', 'model' => Order::class],
        ['discount', 'model' => OrderDiscount::class],
    ];

    /**
     * @return Order
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @return OrderDiscount
     */
    public function getDiscount()
    {
        return $this->discount;
    }

    /**
     * @return float
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Alias di getName() da usare nel tema.
     *
     * @return string
     */
    public function name()
    {
        return $this->getName();
    }

    /**
     * @return float
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * Alias di getValue() da usare nel tema.
     *
     * @return float
     */
    public function value()
    {
        return $this->getValue();
    }

    /**
     * Restituisce il valore formattato dello sconto.
     *
     * @return string
     */
    public function getFormatValue()
    {
        return format_price($this->getValue());
    }

    /**
     * Alias di getFormatValue() da usare nel tema.
     *
     * @return string
     */
    public function formatValue()
    {
        return $this->getFormatValue();
    }
}
