<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Installer;

use Application\Cms\Model\NodeType;
use Application\Cms\Model\Taxonomy;
use Application\Cms\Model\Term;
use Application\Cms\Utilities\TaxonomyBuilder;
use Application\Core\Model\Language;

/**
 * NodeTypeConverter
 */
class NodeTypeConverter
{
    /**
     * @var TaxonomyBuilder
     */
    protected $taxonomy_builder;

    /**
     * @param TaxonomyBuilder $taxonomy_builder
     */
    public function __construct(TaxonomyBuilder $taxonomy_builder)
    {
        $this->taxonomy_builder = $taxonomy_builder;
    }

    /**
     * @param NodeType $node_type
     * @return bool
     */
    public function convert(NodeType $node_type)
    {
        // TODO: FS#454 - Permessi taglie

        $this->buildTaxonomies($node_type);

        $module = $node_type->module;
        $module->controller = 'Application\\Showcase\\Controller\\NodeController';
        $module->save();

        return true;
    }

    /**
     * @param NodeType $node_type
     * @return bool
     */
    public function convertToBase(NodeType $node_type)
    {
        $module = $node_type->module;
        $module->controller = 'Application\\Cms\\Controller\\NodeController';
        $module->save();

        return true;
    }

    /**
     * @param NodeType $node_type
     */
    protected function buildTaxonomies(NodeType $node_type)
    {
        $this->taxonomy_builder->build($node_type, 'category', Taxonomy::MODE_HIERARCHY, false, true, Term::MANUAL_ORDER_OPTION);
        $this->taxonomy_builder->build($node_type, 'brand', Taxonomy::MODE_NORMAL, false, true, Term::ORDER_BY_TITLE_ASC_OPTION);

        /**
         * @var Language $language_it
         *
         * TODO: LanguageManager
         */
        $language_it = Language::first([
            'conditions' => ['iso = ?', 'it'],
        ]);

        if ($language_it) {
            $node_type->addTranslationStrings(
                $language_it->id,
                [
                    'taxonomy_category'           => 'Categoria',
                    'taxonomy_category_plural'    => 'Categorie',
                    'taxonomy_category_add'       => 'Aggiungi categoria',
                    'taxonomy_category_edit'      => 'Modifica la categoria “%s“',
                    'taxonomy_category_add_first' => 'Aggiungi la prima categoria',
                    'permit_taxonomy_category'    => 'Può gestire le categorie',
                    'taxonomy_brand'              => 'Marca',
                    'taxonomy_brand_plural'       => 'Marche',
                    'taxonomy_brand_add'          => 'Aggiungi marca',
                    'taxonomy_brand_edit'         => 'Modifica la marca “%s“',
                    'taxonomy_brand_add_first'    => 'Aggiungi la prima marca',
                    'permit_taxonomy_brand'       => 'Può gestire le marche',
                ]
            );
        }
    }
}
