<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\GoogleShopping;

use Application\Core\Entity\SiteInterface;
use Pongho\Sdk\GoogleShopping\Product as BaseProduct;
use Pongho\Sdk\GoogleShopping\Property\AdditionalImageLinkProperty;
use Pongho\Sdk\GoogleShopping\Property\AvailabilityProperty;
use Pongho\Sdk\GoogleShopping\Property\BrandProperty;
use Pongho\Sdk\GoogleShopping\Property\ConditionProperty;
use Pongho\Sdk\GoogleShopping\Property\GoogleProductCategoryProperty;
use Pongho\Sdk\GoogleShopping\Property\ProductTypeProperty;
use Pongho\Sdk\GoogleShopping\Property\SizeTypeProperty;

/**
 * Product.
 */
class Product extends BaseProduct
{
    /**
     * @var int
     */
    protected $product_id;

    /**
     * @var int
     */
    protected $featured_image_id;

    /**
     * @var int
     */
    protected $module_site_id;

    /**
     * @var string
     */
    protected $node_type;

    /**
     * @var float
     */
    protected $discount;

    /**
     * @var string
     */
    protected $discount_type;

    /**
     * @var int
     */
    protected $availabilities;

    /**
     * @param SiteInterface $site
     */
    public function __construct(SiteInterface $site)
    {
        $this->product_id = (int) $this->item_group_id;
        $this->module_site_id = (int) $this->module_site_id;

        if ($this->link) {
            $this->link = $site->getDomain() . '/' . ltrim($this->link, '/');
        }

        if ($this->mobile_link) {
            $this->mobile_link = $site->getDomain() . '/' . ltrim($this->mobile_link, '/');
        } else {
            $this->mobile_link = $this->link;
        }

        $this->additional_images_links = [];

        $this->identifier_exists = (bool) ($this->gtin || $this->mpn);

        if ($this->discount) {
            if ($this->discount_type === '%') {
                $this->sale_price = $this->price * (100 - $this->discount) / 100;
            } else {
                $this->sale_price = $this->price - $this->discount;
            }
        }

        // TODO: Spostare sulla taglia
        $this->condition = ConditionProperty::CONDITION_NEW;
        $this->availability = AvailabilityProperty::AVAILABILITY_IN_STOCK;

        // TODO: Spostare sul tipo di taglia o sulla taglia se custom (in database va salvato sul nodo)
        $this->size_type = SizeTypeProperty::SIZE_TYPE_REGULAR;
        $this->size_system = 'IT';
    }

    /**
     * @return int
     */
    public function getProductId()
    {
        return $this->product_id;
    }

    /**
     * @param string $category
     * @return $this
     */
    public function setProductType($category)
    {
        $this->product_type = new ProductTypeProperty($category);

        return $this;
    }

    /**
     * @param string $category
     * @return $this
     */
    public function setGoogleCategory($category)
    {
        $this->google_product_category = new GoogleProductCategoryProperty($category);

        return $this;
    }

    /**
     * @param string $brand
     * @return $this
     */
    public function setBrand($brand)
    {
        $this->brand = new BrandProperty($brand);

        return $this;
    }

    /**
     * @return int
     */
    public function getFeaturedImageId()
    {
        return (int) $this->featured_image_id;
    }

    /**
     * @param string $image
     */
    public function setImage($image)
    {
        $this->image_link = $image;
    }

    /**
     * @param string $image
     */
    public function addAdditionalImage($image)
    {
        $coll = $this->getAdditionalImagesLinks();
        $coll->add(new AdditionalImageLinkProperty($image));
    }

    /**
     * @return int
     */
    public function getModuleSiteId()
    {
        return $this->module_site_id;
    }

    /**
     * @return string
     */
    public function getNodeType()
    {
        return (string) $this->node_type;
    }

    /**
     * @param string $node_type
     */
    public function setNodeType($node_type)
    {
        $this->node_type = (string) $node_type;
    }

    /**
     * @return int
     */
    public function getAvailabilities()
    {
        return $this->availabilities;
    }
}
