<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\GoogleShopping\Form;

use Application\Admin\Form\FormConfig;
use Application\Core\I18n\Translation\Translator;
use Application\Showcase\GoogleShopping\Form\FieldView\GoogleCategoryFieldView;
use Pongho\Form\Field\TextField;
use Pongho\Template\HeadHelper;
use Pongho\Template\ViewClosure;

/**
 * TermFormConfigFilter
 */
class TermFormConfigFilter
{
    /**
     * @var Translator
     */
    protected $translator;

    /**
     * @var HeadHelper
     */
    protected $head;

    /**
     * @param Translator               $translator
     * @param HeadHelper               $head
     */
    public function __construct(Translator $translator, HeadHelper $head)
    {
        $this->translator = $translator;
        $this->head = $head;
    }

    /**
     * @param FormConfig $config
     * @return FormConfig
     */
    public function filter(FormConfig $config)
    {
        $this->addGoogleProductCategoryField($config);

        return $config;
    }

    /**
     * @param FormConfig $config
     * @return $this
     */
    protected function addGoogleProductCategoryField(FormConfig $config)
    {
        $config->addField('content/main/sidebar/gs_category', $this->fieldGoogleProductCategory());

        return $this;
    }

    /**
     * @return array
     */
    protected function fieldGoogleProductCategory()
    {
        return [
            'class'    => TextField::class,
            'label'    => $this->translator->trans('Google Product Category'),
            'settings' => [
                'view' => new ViewClosure(new GoogleCategoryFieldView($this->head)),
            ],
        ];
    }
}
