<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\GoogleShopping;

use Application\Core\Model\Site;
use Application\Showcase\Model\Manager\GoogleShoppingProductManager;
use Pongho\Sdk\GoogleShopping\FeedProviderInterface;

/**
 * FeedProvider.
 */
class FeedProvider implements FeedProviderInterface
{
    /**
     * @var GoogleShoppingProductManager
     */
    protected $manager;

    /**
     * @var Site
     */
    protected $site;

    /**
     * @param GoogleShoppingProductManager $manager
     * @param Site                         $site
     */
    public function __construct(GoogleShoppingProductManager $manager, Site $site)
    {
        $this->manager = $manager;
        $this->site = $site;
    }

    /**
     * {@inheritdoc}
     */
    public function getProducts()
    {
        return $this->manager->findAll();
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->site->getName();
    }

    /**
     * {@inheritdoc}
     */
    public function getLink()
    {
        return $this->site->getPermalink();
    }

    /**
     * {@inheritdoc}
     */
    public function getDescription()
    {
        return $this->site->getOption('slogan'); // TODO: Forse è meglio mettere un campo apposito...
    }
}
