<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Form\Field;

use Pongho\Form\Fieldset;

/**
 * PaymentMethodOptionsFieldset
 */
class PaymentMethodOptionsFieldset extends Fieldset
{
    /**
     * @var array
     */
    private $paymentOptions;

    /**
     * {@inheritdoc}
     */
    public function __construct($key)
    {
        parent::__construct($key, true);
    }

    /**
     * {@inheritdoc}
     */
    public function getSubject()
    {
        return $this->getForm()->getSubject();
    }

    /**
     * {@inheritdoc}
     */
    public function getValue($key)
    {
        if ($this->isCurrentPaymentMethod()) {
            /** @var \Application\Showcase\Model\Payment $payment */
            $payment = $this->getSubject()->getModel();

            return $payment->getHandlerOption($key);
        }

        return null;
    }

    public function handle(array $request)
    {
        /** @var \Application\Showcase\Model\Payment $payment */
        $payment = $this->getSubject()->getModel();

        $this->paymentOptions = $payment->getHandlerOptions();

        parent::handle($request);

        if ($this->handled) {
            /** @var \Application\Showcase\Model\Payment $payment */
            $payment = $this->getSubject()->getModel();
            $payment->setHandlerOptions($this->paymentOptions);
            $payment->save();
        }

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function setValue($key, $value)
    {
        if (null === $this->paymentOptions) {
            $this->paymentOptions = [];
        }

        if ($this->isCurrentPaymentMethod()) {
            $this->paymentOptions[$key] = $value;
        }

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    protected function afterHandleFieldsCallback(array $request)
    {
        return true;
    }

    /**
     * @return bool
     */
    private function isCurrentPaymentMethod()
    {
        /**
         * @var \Application\Showcase\Model\Payment              $payment
         * @var string|\Application\Showcase\Payment\BasePayment $className
         */
        $payment = $this->getSubject()->getModel();
        $className = $payment->handler_class;

        if (!$className) {
            return false;
        }

        return $className::getName() === substr($this->getKey(), 0, -8);
    }
}
