<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Domain\Order\Command;

use Application\Core\Model\Site;
use Application\Core\Utilities\Mailer;
use Application\Showcase\Model\Order;
use Pongho\Core\LocalizationInterface;
use Pongho\Template\View;

/**
 * ProcessOrderNotifier
 */
class ProcessOrderNotifier
{
    /**
     * @var Mailer
     */
    protected $mailer;

    /**
     * @var Site
     */
    protected $site;

    /**
     * @var View
     */
    protected $view;

    /**
     * @var LocalizationInterface
     */
    protected $lang;

    /**
     * @param Mailer                $mailer
     * @param Site                  $site
     * @param View                  $view
     * @param LocalizationInterface $lang
     */
    public function __construct(Mailer $mailer, Site $site, View $view, LocalizationInterface $lang)
    {
        $this->mailer = $mailer;
        $this->site = $site;
        $this->view = $view;
        $this->lang = $lang;
    }

    /**
     * @param Order               $order
     * @param \Swift_Attachment[] $attachments
     *
     * @customized HDC
     */
    public function send(Order $order, array $attachments = [])
    {
        $companyName = $this->site->getOption('company_name');
        $companyEmail = $this->site->getOption('company_orders_email', $this->site->getOption('company_email'));

        $customerName = $order->getCustomerName();
        $customerEmail = $order->getCustomerEmail();

        $this->view->assignVars([
            'order'          => $order,
            'order_user_url' => $this->site->getPermalink() . 'shop/order/' . $order->id . '/',
        ]);

        $this->mailer->send(
            [$companyEmail => $companyName], // From
            [$customerEmail => $customerName], // To
            sprintf($this->lang->get('email_shop_order_processed_subject'), $this->site->getName(), $order->id),
            // Subject
            $this->mailer->content(
                $this->site->getThemesPath('email/base.php'),
                [
                    'CONTENT' => $this->view->render(),
                ]
            ),
            null,
            $attachments
        );
    }
}
