<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Domain\Order\Command;

use Application\Core\I18n\Translation\Translator;
use Application\Showcase\Model\Order;
use Pongho\Http\Request;
use Pongho\Utilities\DateTime;

/**
 * ConfirmOrderPaymentCommandFactory
 */
class ConfirmOrderPaymentCommandFactory
{
    /**
     * @var Translator
     */
    protected $translator;

    /**
     * @param Translator $translator
     */
    public function __construct(Translator $translator)
    {
        $this->translator = $translator;
    }

    /**
     * @param Order   $order
     * @param Request $request
     * @return ConfirmOrderPaymentCommand
     */
    public function createFromRequest(Order $order, Request $request)
    {
        $attributes = $request->post->get('order', []);

        if (!is_array($attributes)) {
            $attributes = [];
        }

        $command = $this->createCommand();

        $command
            ->reset()
            ->setOrder($order)
            ->setDate($this->extractPaymentDate($attributes));

        return $command;
    }

    /**
     * @return ConfirmOrderPaymentCommand
     */
    public function createCommand()
    {
        return new ConfirmOrderPaymentCommand($this->translator);
    }

    /**
     * @param array $attributes
     * @return DateTime
     */
    protected function extractPaymentDate(array $attributes)
    {
        $paidDate = isset($attributes['paid_at']) ? $attributes['paid_at'] : 'now';

        try {
            return new DateTime($paidDate);
        } catch (\Exception $e) {
            return new DateTime('now');
        }
    }
}
