<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Discount\Order;

use Application\Showcase\Model\Order;

/**
 * OrderDiscountsFacade
 */
final class OrderDiscountsHandler
{
    public function applyDiscount(Order $order, OrderDiscountTypeInterface $discountMethod)
    {
        $discountMethod->applyToOrder($order);

        return $this;
    }

    public function removeDiscount(Order $order, OrderDiscountTypeInterface $discountMethod)
    {
        $discountMethod->removeFromOrder($order);

        return $this;
    }

    public function updateDiscounts(Order $order)
    {
    }
}
