<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Discount\Order;

use Application\Showcase\Model\Order;

/**
 * DiscountMethodInterface
 */
interface OrderDiscountTypeInterface
{
    /**
     * @param Order $order
     */
    public function applyToOrder(Order $order);

    /**
     * @param Order $order
     */
    public function removeFromOrder(Order $order);

    /**
     * @param Order $order
     * @param float $total
     * @return float
     */
    public function recalculateDiscountValue(Order $order, $total = null);
}
