<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Discount;

/**
 * ProductOfferCalculator
 */
class DiscountCalculator implements DiscountCalculatorInterface
{
    /**
     * @inheritdoc
     */
    public function calculate($price, $discount = 0.0, $discountType = '')
    {
        if ($discount) {
            if ($discountType === '%') {
                return $price * (100 - $discount) / 100;
            } else {
                return $price - $discount;
            }
        } else {
            return $price;
        }
    }
}
