<?php

/**
 * Questo file è parte di Pongho (Dev).
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Cms
 */

namespace Application\Showcase\DependencyInjection;

use Application\Showcase\Controller\GoogleShoppingController;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Routing\Route;
use Pongho\Routing\RoutesCollection;

/**
 * RoutingServiceProvider
 */
class RoutingServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->extend(
            'routes_collection',
            function (RoutesCollection $collection) {
                $collection->add(
                    'google-shopping',
                    new Route(
                        '/google-shopping.xml',
                        ['_controller' => GoogleShoppingController::class]
                    ),
                    -10
                );
            }
        );
    }
}
