<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\DependencyInjection;

use Application\Showcase\GoogleShopping\FeedProvider;
use Application\Showcase\GoogleShopping\Form\NodeFormConfigFilter;
use Application\Showcase\GoogleShopping\Form\TermFormConfigFilter;
use Application\Showcase\GoogleShopping\Translator;
use Application\Showcase\Model\Manager\GoogleShoppingProductManager;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Sdk\GoogleShopping\FeedGenerator;
use Pongho\Sdk\GoogleShopping\ProductValidator;

/**
 * GoogleShoppingServiceProvider
 */
class GoogleShoppingServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->share('google_shopping_product_manager', [$this, 'getProductManager']);
        $container->share('google_shopping_product_validator', [$this, 'getProductValidator']);
        $container->share('google_shopping_feed_provider', [$this, 'getFeedProvider']);
        $container->share('google_shopping_feed_generator', [$this, 'getFeedGenerator']);
        $container->share('google_shopping_translator', [$this, 'getTranslator']);

        $container->share('google_shopping_node_form_config_filter', [$this, 'getNodeFormConfigFilter']);
        $container->share('google_shopping_term_form_config_filter', [$this, 'getTermFormConfigFilter']);
    }

    /**
     * @param Container $container
     * @return GoogleShoppingProductManager
     */
    public function getProductManager(Container $container)
    {
        return new GoogleShoppingProductManager(
            $container->get('connection'),
            $container->get('language_site')
        );
    }

    /**
     * @param Container $container
     * @return ProductValidator
     */
    public function getProductValidator(Container $container)
    {
        return new ProductValidator(
            $container->get('google_shopping_translator')
        );
    }

    /**
     * @param Container $container
     * @return FeedProvider
     */
    public function getFeedProvider(Container $container)
    {
        return new FeedProvider(
            $container->get('google_shopping_product_manager'),
            $container->get('site')
        );
    }

    /**
     * @param Container $container
     * @return FeedGenerator
     */
    public function getFeedGenerator(Container $container)
    {
        return new FeedGenerator(
            $container->get('google_shopping_feed_provider'),
            $container->get('google_shopping_product_validator')
        );
    }

    /**
     * @param Container $container
     * @return Translator
     */
    public function getTranslator(Container $container)
    {
        return new Translator(
            $container->get('translator')
        );
    }

    /**
     * @param Container $container
     * @return NodeFormConfigFilter
     */
    public function getNodeFormConfigFilter(Container $container)
    {
        return new NodeFormConfigFilter(
            $container->get('translator'),
            $container->get('admin.template_head')
        );
    }

    /**
     * @param Container $container
     * @return TermFormConfigFilter
     */
    public function getTermFormConfigFilter(Container $container)
    {
        return new TermFormConfigFilter(
            $container->get('translator'),
            $container->get('admin.template_head')
        );
    }
}
