<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\DependencyInjection;

use Application\Admin\AdminSidebar\Sidebar;
use Application\Cms\Controller\Admin\TermsController;
use Application\Showcase\Controller\Admin\CouponsController;
use Application\Showcase\Controller\Admin\GoogleShoppingController;
use Application\Showcase\Controller\Admin\OrdersAmountDiscountController;
use Application\Showcase\Controller\Admin\OrdersController;
use Application\Showcase\Controller\Admin\PaymentsController;
use Application\Showcase\Controller\Admin\ShippingsController;
use Application\Showcase\Controller\Admin\ShopOptionsController;
use Application\Showcase\Controller\Admin\ShowcaseNodesController;
use Application\Showcase\Controller\Admin\ShowcaseOptionsController;
use Application\Showcase\Controller\Admin\SizesController;
use Application\Showcase\Controller\Admin\StatsController;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Utilities\Inflector;

/**
 * AdminSidebarServiceProvider
 */
class AdminSidebarServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->extend('admin_sidebar', [$this, 'addSidebarItems']);
    }

    /**
     * @param Sidebar   $sidebar
     * @param Container $container
     */
    public function addSidebarItems(Sidebar $sidebar, Container $container)
    {
        /**
         * @var \Application\Core\Model\LanguageSite           $languageSite
         * @var \Application\Cms\Model\Manager\NodeTypeManager $nodeTypeManager
         * @var \Application\Cms\AdminSidebar\NodeTypeFiller   $nodeTypeFiller
         * @var \Application\Core\I18n\Translation\Translator  $translator
         * @var \Application\Core\User                         $user
         */
        $languageSite = $container->get('language_site');
        $nodeTypeManager = $container->get('node_type_manager');
        $nodeTypeFiller = $container->get('admin_sidebar_node_type_filler');
        $translator = $container->get('translator');
        $user = $container->get('current_user');

        foreach ($nodeTypeManager->findAllNodeTypes($languageSite->language_id, true, false) as $nodeType) {
            $nodeTypeNamePlural = Inflector::pluralize($nodeType->getNodeType());

            if ($user->isFounder()) {
                $sidebar->addRoute(
                    '/' . $nodeTypeNamePlural . '-showcase-converter/',
                    'Application\\Showcase\\Controller\\Admin\\NodeTypeConverterController',
                    $nodeType->module_id
                );
            }

            if ($nodeType->getApplication() !== 'Showcase') {
                continue;
            }

            $permit_prefix = 'node_' . $nodeType->getNodeType();
            if ($user->hasPermit($permit_prefix . '.admin')) {
                $nodeTypeFiller->fill($sidebar, $nodeType, [
                    'archive_controller' => ShowcaseNodesController::class,
                    'node_controller'    => ShowcaseNodesController::class,
                    'term_controller'    => TermsController::class,
                    'options_controller' => ShowcaseOptionsController::class,
                ]);

                // TODO: FS#454 - Permessi taglie
                if ($nodeType->getOption('enable_sizes') && $user->hasPermit('shop.admin.sizes')) {
                    $sidebar->addItem(
                        $translator->trans('Sizes'),
                        '/' . $nodeTypeNamePlural . '-sizes/',
                        'node_' . $nodeType->getNodeType(),
                        Sidebar::POS_PANEL_FEATURES,
                        SizesController::class,
                        $nodeType->module_id
                    );
                }
            }
        }

        // Shop
        if ($user->hasPermit('shop.admin.')) {
            /** @var \Application\Core\Model\Site $site */
            $site = $container->get('site');

            $sidebar->addPanel($translator->trans('Shop'), 'shop', 'shop', Sidebar::POS_APPS);

            if ($user->hasPermit('shop.admin.orders')) {
                $sidebar->addItem(
                    $translator->trans('Orders'),
                    '/shop-orders/',
                    'shop',
                    Sidebar::POS_PANEL_FEATURES,
                    OrdersController::class
                );
            }

            if ($user->hasPermit('shop.admin.payments.manage')) {
                $sidebar->addItem(
                    $translator->trans('Payments'),
                    '/shop-payments/',
                    'shop',
                    Sidebar::POS_PANEL_FEATURES,
                    PaymentsController::class
                );
            }

            if ($user->hasPermit('shop.admin.shippings.manage')) {
                $sidebar->addItem(
                    $translator->trans('Shippings'),
                    '/shop-shippings/',
                    'shop',
                    Sidebar::POS_PANEL_FEATURES,
                    ShippingsController::class
                );
            }

            /** @var \Application\Showcase\Discount\OrderDiscounts $orderDiscounts */
            $orderDiscounts = $container->get('shop_order_discounts');

            if ($user->hasPermit('shop.admin.coupons') && $orderDiscounts->isEnabled('coupon_code')) {
                $sidebar->addItem(
                    $translator->trans('Coupons'),
                    '/shop-coupons/',
                    'shop',
                    Sidebar::POS_PANEL_FEATURES,
                    CouponsController::class
                );
            }

            if ($user->hasPermit('shop.admin.orders_amount_discount') && $orderDiscounts->isEnabled('order_amount')) {
                $sidebar->addItem(
                    $translator->trans('Order amount discounts'),
                    '/shop-order-amount-discount/',
                    'shop',
                    Sidebar::POS_PANEL_FEATURES,
                    OrdersAmountDiscountController::class
                );
            }

            if ($user->hasPermit('shop.admin.google_shopping') && $site->getOption('enable_google_shopping')) {
                $sidebar->addItem(
                    $translator->trans('Google Shopping'),
                    '/shop-google-shopping/',
                    'shop',
                    Sidebar::POS_PANEL_FEATURES,
                    GoogleShoppingController::class
                );
            }

            if ($user->hasPermit('shop.admin.stats')) {
                $sidebar->addItem(
                    $translator->trans('Stats'),
                    '/shop-stats/',
                    'shop',
                    Sidebar::POS_PANEL_FEATURES,
                    StatsController::class
                );
            }

            if ($user->isFounder()) {
                $sidebar->addItem(
                    $translator->trans('Options'),
                    '/shop-options/',
                    'shop',
                    Sidebar::POS_PANEL_SETTINGS,
                    ShopOptionsController::class
                );
            }
        }
    }
}
