<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Controller;

use Application\Core\Controller;
use Pongho\Http\Exception\HttpNotFoundException;
use Pongho\Http\Response;
use Pongho\Sdk\GoogleShopping\FeedGenerator;

/**
 * GoogleShoppingController
 */
class GoogleShoppingController extends Controller
{
    /**
     * @return null|\Pongho\Http\Response
     */
    public function indexAction()
    {
        $site = $this->getHelper()->getSite();

        if (!$site->getOption('enable_google_shopping')) {
            throw new HttpNotFoundException();
        }

        /** @var FeedGenerator $generator */
        $generator = $this->getContainer()->get('google_shopping_feed_generator');

        return new Response($generator->generate(), ['Content-Type' => 'text/xml; charset=UTF-8']);
    }
}
