<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Controller\Admin\Orders;

use Application\Showcase\Model\Order;
use Pongho\Http\Request;

/**
 * OrderEditPanelInterface
 */
interface OrderEditPanelInterface
{
    /**
     * @return string
     */
    public function getId();

    /**
     * @return string
     */
    public function getLabel();

    /**
     * @param Order $order
     * @return string
     */
    public function renderPanel(Order $order);

    /**
     * @param Order   $order
     * @param Request $request
     */
    public function handleRequest(Order $order, Request $request);
}
