<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Controller\Admin\Orders;

/**
 * OrderEditPanelCollection
 */
class OrderEditPanelCollection implements \Countable, \IteratorAggregate
{
    /**
     * @var OrderEditPanelInterface[]
     */
    private $collection = [];

    /**
     * @param OrderEditPanelInterface $form
     * @return $this
     */
    public function push(OrderEditPanelInterface $form)
    {
        $this->collection[$form->getId()] = $form;

        return $this;
    }

    /**
     * @param string $id
     * @return bool
     */
    public function has($id)
    {
        return isset($this->collection[$id]);
    }

    /**
     * @param string $id
     * @return OrderEditPanelInterface
     */
    public function get($id)
    {
        if (isset($this->collection[$id])) {
            return $this->collection[$id];
        }

        throw new \InvalidArgumentException(sprintf("The order edit panel '%s' does not exist.", $id));
    }

    /**
     * {@inheritdoc}
     */
    public function count()
    {
        return count($this->collection);
    }

    /**
     * {@inheritdoc}
     *
     * return OrderEditFormInterface[]
     */
    public function getIterator()
    {
        return new \ArrayIterator($this->collection);
    }
}
