<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

use Application\Showcase\Entity\OrderInterface;
use Application\Showcase\WebTracking\GoogleAnalytics\Ecommerce;

/**
 * Genera il codice di tracciamento di Google Analytics Ecommerce.
 *
 * @link https://developers.google.com/analytics/devguides/collection/analyticsjs/ecommerce
 *
 * @param string         $taxonomy
 * @param string         $affiliation
 * @param string         $tracker
 * @return string
 */
function ga_ecommerce_js(OrderInterface $order, $taxonomy = 'category', $affiliation = null, $tracker = null)
{
    $ga = new Ecommerce();

    return $ga->render($order, $taxonomy, $affiliation, $tracker);
}
