<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Utilities;

use Application\Core\Model\Site;

/**
 * Gestisce il calcolo delle tasse.
 */
class Taxation
{
    /**
     * Sito con le opzioni per il calcolo delle tasse.
     *
     * @var \Application\Core\Model\Site
     */
    protected $site;

    public function __construct(Site $site)
    {
        $this->site = $site;
    }

    /**
     * Aggiunge le tasse al prezzo passato e lo restituisce.
     *
     * @param float $price
     * @return float
     */
    public function calculate($price)
    {
        if ($this->site->getOption('enable_tax')) {
            return ((float) $price) * (100 + $this->site->getOption('tax_value', 0)) / 100;
        }

        return $price;
    }

    /**
     * Restituisce il costo delle tasse sul prezzo passato.
     *
     * @param float $price
     * @return float
     */
    public function get($price)
    {
        if ($this->site->getOption('enable_tax')) {
            return ((float) $price) * $this->site->getOption('tax_value', 0) / 100;
        }

        return 0;
    }
}
