<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Utilities;

class CheckoutOptions
{
    /**
     * @var bool
     */
    protected $enableStandardShippingMethods = true;

    /**
     * @param bool $enable
     * @return $this
     */
    public function enableStandardShippingMethods($enable = true)
    {
        $this->enableStandardShippingMethods = (bool) $enable;

        return $this;
    }

    /**
     * @return bool
     */
    public function isStandardShippingMethodsEnabled()
    {
        return $this->enableStandardShippingMethods;
    }
}
